package com.bycom.versapro.MenuTypes.WordPress.Adapters;

import static com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment.TYPE_POSTS_BY_CATEGORY;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.recyclerview.widget.RecyclerView;
import com.bycom.versapro.R;

import com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment;
import com.google.android.material.card.MaterialCardView;
import com.wordpress.restapi.Serializables.WPCategory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;

public class WPCategoryAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    AppCompatActivity activity;
    String BASE_URL;
    ArrayList<WPCategory>categories;
    HashMap<Integer, WPCategory> categoryHashMap;
    Fragment fragment;

    public WPCategoryAdapter(AppCompatActivity activity, Fragment fragment, HashMap<Integer, WPCategory> categories, String BASE_URL) {
        this.fragment = fragment;
        this.activity = activity;
        this.categories = categories.values().stream()
                .filter(category -> category.getPost_count() > 0)
                .collect(Collectors.toCollection(ArrayList::new));
        this.categoryHashMap = categories;
        this.BASE_URL = BASE_URL;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from(activity);
        View view = inflater.inflate(R.layout.item_wp_category, parent, false);
        return new CategoryViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {


        CategoryViewHolder holder = (CategoryViewHolder) viewHolder;

        holder.tv_name.setText(categories.get(position).getName());

        holder.itemView.setOnClickListener(v -> {
            WPPostFragment wordPressFragment = new WPPostFragment();
            Bundle bundle = new Bundle();
            bundle.putInt("TYPE",TYPE_POSTS_BY_CATEGORY);
            bundle.putString("BASE_URL",BASE_URL);
            bundle.putSerializable("CATEGORY",categories.get(holder.getAdapterPosition()));
            wordPressFragment.setArguments(bundle);
            FragmentTransaction transaction = activity.getSupportFragmentManager().beginTransaction();
            transaction.hide(fragment);
            transaction.add(R.id.container, wordPressFragment);
            transaction.addToBackStack(null);
            transaction.commit();
        });

    }


    @Override
    public int getItemCount() {
        return categories.size();
    }


    public static class CategoryViewHolder extends RecyclerView.ViewHolder{

        TextView tv_name;
        MaterialCardView mcv;

        public CategoryViewHolder(@NonNull View itemView) {
            super(itemView);
            tv_name = itemView.findViewById(R.id.tv_name);
            mcv = itemView.findViewById(R.id.mcv);
        }
    }






}
